<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FreelanceVoiceSample extends Model 
{

    protected $table = 'fl_voice_samples';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('fl_users_id', 'fl_job_category_id', 'sample');

    public function freelanceUser()
    {
        return $this->belongsTo('App\Models\FreelanceUsers', 'fl_user_id', 'id');
    }

    public function jobCategory()
    {
        return $this->belongsTo('App\Models\FreelanceJobCategory', 'fl_job_category_id', 'id');
    }

}